/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.schedops.beans;

import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.schedops.DisplayDataNew;
import com.ibm.hwmca.fw.servlet.pmod.PanelModel;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public final class AddSchedOpsBean
extends PanelBean
implements DataBean {
    private static final String CLASS_NAME = "[AddSchedOpsBean] ";
    private static final String TRACE_MASKT = "XTIMxxxT";
    private static final String TRACE_MASKF = "XTIMxxxF";
    private static final String TRACE_MASKD = "XTIMxxxD";
    private static final String OBJECT_GROUP = "SelectOptionsGB";
    private static final String OBJECT_TABLE = "ObjectTable";
    private static final String OPERATION_TABLE = "SchedOperOpsTable";
    private static final String OK_BUTTON = "OKButton";
    private static final String CANCEL = "CANCEL";
    private ItemDescriptor[] m_idObjectTable;
    private ColumnDescriptor[] m_cdObjectTableStructure;
    private int[] m_iObjectTableSelection;
    private ItemDescriptor[] m_idSchedOperOpsTable;
    private ColumnDescriptor[] m_cdSchedOperOpsTableStructure;
    private int[] m_iSchedOperOpsTableSelection;
    private boolean targetHMC = false;
    private ArrayList displayData = new ArrayList();
    private ObjectId currentObjectID = null;
    private Integer currentSchedulable = null;
    private ArrayList currentSchedulables = new ArrayList();
    private Lock dataLock = new Lock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddSchedOpsBean(String name, ArrayList data, boolean flag) {
        Trace.trace(TRACE_MASKT, "[AddSchedOpsBean] >> AddSchedOpsBean()");
        this.setBeanName(name);
        this.targetHMC = flag;
        Lock lock = this.dataLock;
        synchronized (lock) {
            this.displayData = data;
        }
        Trace.trace(TRACE_MASKT, "[AddSchedOpsBean] << AddSchedOpsBean()");
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "[AddSchedOpsBean] >> prepare() : BEAN=" + this.getBeanName());
        if (this.getObjectTableRowCount() > 0) {
            this.setObjectTableSelection(new int[]{0});
        }
        if (this.targetHMC || this.getObjectTableRowCount() == 1) {
            this.userTaskManager.setShown(this.getMountPrefix() + OBJECT_GROUP, false);
            this.userTaskManager.setShown(this.getMountPrefix() + OBJECT_TABLE, false);
        }
        Trace.trace(TRACE_MASKT, "[AddSchedOpsBean] << prepare()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void panelAction(TaskActionEvent event) {
        Trace.trace(TRACE_MASKT, "[AddSchedOpsBean] >> panelAction() : \n\tBean Name     : " + this.getBeanName() + "\n\tCurrentElement: " + event.getCurrentElement() + "\n\tElementName   : " + event.getElementName() + "\n\tActionCommand : " + event.getActionCommand());
        String elementName = event.getElementName();
        String actionCommand = event.getActionCommand();
        if (actionCommand.endsWith(OK_BUTTON)) {
            HashMap<String, Comparable> map = null;
            Lock lock = this.dataLock;
            synchronized (lock) {
                if (this.currentObjectID != null && this.currentSchedulable != null) {
                    map = new HashMap<String, Comparable>();
                    map.put("OBJECTID", this.currentObjectID);
                    map.put("UNIQUEID", this.currentSchedulable);
                    Trace.trace(TRACE_MASKF, "[AddSchedOpsBean]    ObjectID  = " + this.currentObjectID);
                    Trace.trace(TRACE_MASKF, "[AddSchedOpsBean]    Operation = " + this.currentSchedulable);
                }
            }
            if (map != null) {
                this.sendTaskletRequest(actionCommand, map);
            }
        } else if (actionCommand.endsWith(CANCEL)) {
            this.sendTaskletRequest(actionCommand, null);
        }
        Trace.trace(TRACE_MASKT, "[AddSchedOpsBean] << panelAction()");
    }

    public void setButtonStates() {
        int[] sel1 = this.getObjectTableSelection();
        int[] sel2 = this.getSchedOperOpsTableSelection();
        this.userTaskManager.setEnabled(this.getMountPrefix() + OK_BUTTON, sel1.length > 0 && sel2.length > 0);
    }

    private void sendTaskletRequest(String command, Object data) {
        PanelTaskletRequest request = new PanelTaskletRequest(this.getBeanName() + '.' + command);
        request.setData("SOURCE", this.getBeanName());
        request.setData("ACTION", command);
        request.setData("DATA", data);
        this.postTaskletRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getObjectTableRowCount() {
        int size = 0;
        Lock lock = this.dataLock;
        synchronized (lock) {
            size = this.displayData.size();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemDescriptor[] getObjectTableRowAt(int index) {
        DisplayDataNew data = null;
        Lock lock = this.dataLock;
        synchronized (lock) {
            data = (DisplayDataNew)this.displayData.get(index);
        }
        String name = data.getObjectName().toString();
        this.m_idObjectTable = new ItemDescriptor[1];
        this.m_idObjectTable[0] = new ItemDescriptor(this.getMountPrefix() + name, name);
        return this.m_idObjectTable;
    }

    public int[] getObjectTableSelection() {
        Trace.trace(TRACE_MASKT, "[AddSchedOpsBean] <> getObjectTableSelection() : " + (this.m_iObjectTableSelection.length > 0 ? this.m_iObjectTableSelection[0] : -1));
        return this.m_iObjectTableSelection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObjectTableSelection(int[] selected) throws IllegalUserDataException {
        AddSchedOpsBean addSchedOpsBean = this;
        if (addSchedOpsBean.userTaskManager.getTechnologyType().indexOf("Facade") >= 0 && ((PanelModel)this.userTaskManager).getImplAccess().isSerializationInProgress()) {
            Trace.trace(TRACE_MASKT, "[AddSchedOpsBean] -- Serialization in progress.. skipping this setter");
            return;
        }
        Trace.trace(TRACE_MASKT, "[AddSchedOpsBean] >> setObjectTableSelection() : " + (selected.length > 0 ? selected[0] : -1));
        this.m_iObjectTableSelection = selected;
        Lock lock = this.dataLock;
        synchronized (lock) {
            this.currentObjectID = null;
            this.currentSchedulables = new ArrayList();
            if (selected.length > 0) {
                DisplayDataNew data = (DisplayDataNew)this.displayData.get(selected[0]);
                this.currentObjectID = data.getObjectID();
                this.currentSchedulables = new ArrayList(data.getSchedulables().entrySet());
                Collections.sort(this.currentSchedulables, new SortBySchedulable());
            }
        }
        if (selected.length > 0) {
            this.setSchedOperOpsTableSelection(new int[0]);
        }
        this.userTaskManager.refreshElement(this.getMountPrefix() + OBJECT_TABLE);
        this.userTaskManager.refreshElement(this.getMountPrefix() + OPERATION_TABLE);
        Trace.trace(TRACE_MASKT, "[AddSchedOpsBean] << setObjectTableSelection()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSchedOperOpsTableRowCount() {
        int size = 0;
        Lock lock = this.dataLock;
        synchronized (lock) {
            size = this.currentSchedulables.size();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemDescriptor[] getSchedOperOpsTableRowAt(int index) {
        Lock lock = this.dataLock;
        synchronized (lock) {
            Map.Entry entry = (Map.Entry)this.currentSchedulables.get(index);
            this.m_idSchedOperOpsTable = new ItemDescriptor[1];
            this.m_idSchedOperOpsTable[0] = new ItemDescriptor(this.getMountPrefix() + " : " + index, ((LocalizableText)entry.getValue()).toString());
        }
        return this.m_idSchedOperOpsTable;
    }

    public int[] getSchedOperOpsTableSelection() {
        Trace.trace(TRACE_MASKT, "[AddSchedOpsBean] <> getSchedOperOpsTableSelection() : " + (this.m_iSchedOperOpsTableSelection.length > 0 ? this.m_iSchedOperOpsTableSelection[0] : -1));
        return this.m_iSchedOperOpsTableSelection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSchedOperOpsTableSelection(int[] selected) throws IllegalUserDataException {
        AddSchedOpsBean addSchedOpsBean = this;
        if (addSchedOpsBean.userTaskManager.getTechnologyType().indexOf("Facade") >= 0 && ((PanelModel)this.userTaskManager).getImplAccess().isSerializationInProgress()) {
            Trace.trace(TRACE_MASKT, "[AddSchedOpsBean] -- Serialization in progress.. skipping this setter");
            return;
        }
        Trace.trace(TRACE_MASKT, "[AddSchedOpsBean] >> setSchedOperOpsTableSelection() : " + (selected.length > 0 ? selected[0] : -1));
        this.m_iSchedOperOpsTableSelection = selected;
        Lock lock = this.dataLock;
        synchronized (lock) {
            if (selected.length > 0) {
                Map.Entry entry = (Map.Entry)this.currentSchedulables.get(selected[0]);
                this.currentSchedulable = (Integer)entry.getKey();
            } else {
                this.currentSchedulable = null;
            }
        }
        this.userTaskManager.refreshElement(this.getMountPrefix() + OPERATION_TABLE);
        Trace.trace(TRACE_MASKT, "[AddSchedOpsBean] << setSchedOperOpsTableSelection()");
    }

    public ColumnDescriptor[] getObjectTableRowStructure() {
        return this.m_cdObjectTableStructure;
    }

    public int getObjectTableRowStatus() {
        return 3;
    }

    public void setObjectTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idObjectTable = items;
    }

    public ColumnDescriptor[] getSchedOperOpsTableRowStructure() {
        return this.m_cdSchedOperOpsTableStructure;
    }

    public int getSchedOperOpsTableRowStatus() {
        return 3;
    }

    public void setSchedOperOpsTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idSchedOperOpsTable = items;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
    }

    public void load() {
        this.m_idObjectTable = new ItemDescriptor[0];
        this.m_cdObjectTableStructure = new ColumnDescriptor[0];
        this.m_iObjectTableSelection = new int[0];
        this.m_idSchedOperOpsTable = new ItemDescriptor[0];
        this.m_cdSchedOperOpsTableStructure = new ColumnDescriptor[0];
        this.m_iSchedOperOpsTableSelection = new int[0];
    }

    private static class Lock
    implements Serializable {
    }

    private static class SortBySchedulable
    implements Comparator {
        private SortBySchedulable() {
        }

        public int compare(Object o1, Object o2) {
            Map.Entry e1 = (Map.Entry)o1;
            Map.Entry e2 = (Map.Entry)o2;
            String s1 = ((LocalizableText)e1.getValue()).toString();
            String s2 = ((LocalizableText)e2.getValue()).toString();
            return s1.compareTo(s2);
        }
    }
}

